function check_email_address(email) {
  var re = /^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
  return re.test(email);
}

// ********************* VARIABLES ********************* //

$(document).ready(function(){

// ********************* MOBILE CHECK ********************* //
function detectmob() {                        // function to test if on a mobile device
  var $check = $('#width-check').css('z-index');
  if(!!navigator.userAgent.match(/iPad|iPhone|Android|BlackBerry|Windows Phone|webOS/i)) {
    return true;
  } else if($check != 0) {
    return true;
  } else {
    return false;
  }
}
function setMobile(){
  if(detectmob()){
    $('body').addClass('mobile');
  } else {
    $('body').removeClass('mobile');
  }
}
setMobile();


// ********************* BIO EXPAND ********************* //
$('.expand').click(function (e) {
      var originalHeight = $(this).siblings().css('min-height')
      var autoHeight = $(this).siblings().get(0).scrollHeight

      if ($(this).siblings().hasClass('active')) {
        $(this).siblings().removeClass('active').animate({ height: originalHeight }, { queue: false, duration: 500 })
        $(this).text('Read More [ + ]')
      } else {
        $(this).siblings().addClass('active').animate({ height: autoHeight }, { queue: false, duration: 500 })
        $(this).text('Read Less [ - ]')
      }
    })
// ********************* Responsive Content Table Adjustment ********************* //
var tableFix = function(){
  $('.main table').each(function(){
    if(!$(this).hasClass('nofix')){
      $(this).wrap("<div class='overflow'></div>");
    }
  });
}
tableFix();

var tableSize = function(){   
  $('#inner_main div.overflow').each(function(){
    $(this).find('p.instruction').remove();
    $(this).append('<p class="instruction"><i class="fa fa-arrows-h" aria-hidden="true"></i> Scroll to the right to see the table data.</p>');
    var $width = $(this).width();
    var $scrollWidth = this.scrollWidth;
    if ($scrollWidth > $width) {
      $(this).find('p.instruction').addClass('show');
    }
  });
}
tableSize();

// ********************* TABS ********************* //
var setUpTabs = function(max, $tabs) {              // Pass the maximum number of tabs and the tab container
  var $archive = '<li class="has-sub">Archive<ul class="sub-tabs"></ul></li>';
  var $maxTabs = max;
  $tabs.each(function(){
      $this = $(this);
      var $maxCount = 0;
      $this.find('li').each(function(){$maxCount++;});      
      $this.prepend('<div class="select"><select></select><i class="fas fa-chevron-down"></i></div>');
      var $count = 1;
      var $contentcount = 1;      
      $this.find('li').each(function(){
        if($count == 1) $(this).addClass('active');
        if(($count == $maxTabs) && ($maxTabs != $maxCount)){
          $(this).before($archive);
        }
        if(($count >= $maxTabs) && ($maxTabs != $maxCount)) {
          var $html = $(this).html();
          $(this).attr('data-tab','tab'+$count);            
          var $move = $(this).detach();
          $this.find('ul.sub-tabs').append($move);
          var $option = '<option data-tab="tab'+$count+'">'+$html+'</option>';
          $this.find('select').append($option);
          $count++;
        } else {
          var $html = $(this).html();
          $(this).attr('data-tab','tab'+$count);
          var $option = '<option data-tab="tab'+$count+'">'+$html+'</option>';
          $this.find('select').append($option);
          $count++;  
        }         
      });
      $this.find('div.hold').each(function(){
        if($contentcount == 1) $(this).addClass('active');
        $(this).addClass('tab'+$contentcount);
        $contentcount++;          
      });      
  }); 
}
setUpTabs(4, $('div.tabs.news'));                 // Tabs for the news page
$(".tabs li").not('.has-sub').click(function (e) {
  e.preventDefault();
  e.stopPropagation();
  $('div.tabs li, div.tabs div.hold').removeClass('active');
  var $class = $(this).data('tab');
  $(this).addClass('active');
  $('div.tabs div.hold.'+$class).addClass('active');
  $('div.tabs li.has-sub:has(li.active)').addClass('active');
});
$("div.tabs select").change(function() {
  $('div.tabs div.hold').removeClass('active');
  var $class = $(this).find(':selected').data('tab');
  $('div.tabs div.hold.'+$class).addClass('active');
});
// IPAD DROPDOWN FIX
$("div.tabs li.has-sub").on('touchstart',function () {                // Corrects tab drop down on ipad to work like android
  if (detectmob()) {
    $('body').css('cursor','pointer');
  }
});




// ********************* MOBILE MENU ********************* //

if (window.innerWidth < 1211) { 
var add_mobile_link_handlers = function() {
  var parent_menu_item = $('#top_nav a.top-level.has-submenu');
  $(parent_menu_item).on('click touch', function(e) {
    e.preventDefault()
    if ($(this).hasClass("active")) var parent_selected = true;
    $(parent_menu_item).removeClass('active').siblings('ul').slideUp(300);
    if (!parent_selected) {
      $(this).siblings('ul').slideDown(300);
      $(this).addClass('active');
    }
  });
}
add_mobile_link_handlers();
}

  
// ********************* EMAIL SIGNUP ********************* //
  //Error checking
  $('.required input').focusout(function() {
    if ($(this).val() == "") {
      $(this).parent().addClass("error");
    } else {
      if ($(this).parent().hasClass("signup-email")) {
        if (!check_email_address($(this).val())) {
          $(this).parent().addClass("error");
          $(this).parent().addClass("show-tooltip").delay(5000).queue(function(next){
            $(this).removeClass("show-tooltip");next();
          });
        } else {
          $(this).parent().removeClass('error');
        }
      } else {
          $(this).parent().removeClass('error');
      }
    }
  });

  $('form.signup').submit ( function() {

    var $message = $(this).next('.signup-message'); // Variable for selecting appropriate signup message
    var $signuptext = $('#signup-text');
    $message.empty().hide();

    var $form = $(this),
      formData = $form.serialize(),
      formArray = $form.serializeArray(),
      formUrl = $form.attr('action'),
      formMethod = $form.attr('method'),
      responseMsg = $message;
      console.log(formData);
    $.ajax({
      url: formUrl,
      type: formMethod,
      data: formData,

      success:function(data){
        
        var responseData = jQuery.parseJSON(data);
        switch(responseData.SUCCESS){
        case 'false':
          grecaptcha.reset();
          $form.show();
          responseMsg.empty().hide().fadeIn('slow').append(responseData.CONFIRMATION);
          break;
        case 'true':
          $form.hide();
          responseMsg.empty().hide().fadeIn('slow').append(responseData.CONFIRMATION);
          $signuptext.empty().hide();
          window.setTimeout(function(){
            $('.signup_overlay').removeClass('show'); 
          }, 2500); 
          break;
        }
      }
    })
  return false;
  });

// ********************* RECAPTCHA SHOW ********************* //
$('.form button, .form input').on('click touch', function(){$('.form .g-recaptcha').addClass('show');});


// ********************* RESIZE FUNCTIONS ********************* //
var resizeRotate = function(){
  setMobile();
  tableSize();
}

// Mobile chrome resizes on scroll, add width check to fix
  var width = $(window).width();
  var height = $(window).height();
  $(window).resize(function() {
    if($(window).width() != width || $(window).height() != height){
      setTimeout(function(){resizeRotate();},250);
    }
  });

  // Device orintation change check
  if(detectmob()) {
    $( window ).on( "orientationchange", function( event ) {
      resizeRotate();
    });
  }

});
